package com.agilex.healthcare.veteranappointment.utils.linkbuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;
import com.agilex.healthcare.veteranappointment.domain.VARPatientDataCollection;

import java.net.URI;

public abstract class PatientDataLinkBuilder<Ts extends VARPatientDataCollection<T>, T extends PatientData> implements LinkBuilder<Ts, T> {
	private URI baseUri;

	public PatientDataLinkBuilder(URI baseUri) {
		UriDtoValidator.validate(baseUri);
		this.baseUri = baseUri;
	}

	@Override
	public void fillLinks(Ts dataList, URI requestUri) {
		if (dataList != null) {
			UriDtoValidator.validate(dataList);

			dataList.setSelfUri(requestUri);
			fillCustomRelatedLinks(dataList);

			for (T dataItem : dataList) {
				this.fillLinks(dataItem, null);
			}
		}
	}

	@Override
	public void fillLinks(T dataItem, URI requestUri) {
		if (dataItem != null) {
			UriDtoValidator.validate(dataItem);
			UriHelper.setSelfUri(dataItem, requestUri, this.getCannonicalSelfUri(dataItem));
			fillCustomRelatedLinks(dataItem);
		}
	}

	protected String getPath() {
		return this.baseUri.getPath();
	}

//	protected URI extractPatientUri(T dataItem) {
//		return PatientUriHelper.createPatientSelfUri(dataItem.getPatientIdentifier(), baseUri);
//	}

	public abstract URI getCannonicalSelfUri(T dataItem);

	public abstract URI getCannonicalUriForCollection(URI patientUri);

	protected abstract void fillCustomRelatedLinks(T dataItem);

	protected abstract void fillCustomRelatedLinks(Ts dataList);
}
